!function(mod){"object"==typeof exports&&"object"==typeof module?mod(require("../../lib/codemirror"),require("./matchesonscrollbar")):"function"==typeof define&&define.amd?define(["../../lib/codemirror","./matchesonscrollbar"],mod):mod(CodeMirror)}(function(CodeMirror){"use strict";function State(options){for(var name in this.options={},defaults)this.options[name]=(options&&options.hasOwnProperty(name)?options:defaults)[name];this.overlay=this.timeout=null,this.matchesonscroll=null,this.active=!1}function cursorActivity(cm){var state=cm.state.matchHighlighter;(state.active||cm.hasFocus())&&scheduleHighlight(cm,state)}function onFocus(cm){var state=cm.state.matchHighlighter;state.active||(state.active=!0,scheduleHighlight(cm,state))}function scheduleHighlight(cm,state){clearTimeout(state.timeout),state.timeout=setTimeout(function(){highlightMatches(cm)},state.options.delay)}function addOverlay(cm,query,hasBoundary,style){var state=cm.state.matchHighlighter;if(cm.addOverlay(state.overlay=makeOverlay(query,hasBoundary,style)),state.options.annotateScrollbar&&cm.showMatchesOnScrollbar){var searchFor=hasBoundary?new RegExp("\\b"+query+"\\b"):query;state.matchesonscroll=cm.showMatchesOnScrollbar(searchFor,!1,{className:"CodeMirror-selection-highlight-scrollbar"})}}function removeOverlay(cm){var state=cm.state.matchHighlighter;state.overlay&&(cm.removeOverlay(state.overlay),state.overlay=null,state.matchesonscroll&&(state.matchesonscroll.clear(),state.matchesonscroll=null))}function highlightMatches(cm){cm.operation(function(){var state=cm.state.matchHighlighter;if(removeOverlay(cm),cm.somethingSelected()||!state.options.showToken){var from=cm.getCursor("from"),to=cm.getCursor("to");if(from.line==to.line&&(!state.options.wordsOnly||isWord(cm,from,to))){var selection=cm.getRange(from,to);state.options.trim&&(selection=selection.replace(/^\s+|\s+$/g,"")),selection.length>=state.options.minChars&&addOverlay(cm,selection,!1,state.options.style)}}else{for(var re=!0===state.options.showToken?/[\w$]/:state.options.showToken,cur=cm.getCursor(),line=cm.getLine(cur.line),start=cur.ch,end=start;start&&re.test(line.charAt(start-1));)--start;for(;end<line.length&&re.test(line.charAt(end));)++end;start<end&&addOverlay(cm,line.slice(start,end),re,state.options.style)}})}function isWord(cm,from,to){if(null!==cm.getRange(from,to).match(/^\w+$/)){if(from.ch>0){var pos={line:from.line,ch:from.ch-1};if(null===cm.getRange(pos,from).match(/\W/))return!1}if(to.ch<cm.getLine(from.line).length){pos={line:to.line,ch:to.ch+1};if(null===cm.getRange(to,pos).match(/\W/))return!1}return!0}return!1}function boundariesAround(stream,re){return!(stream.start&&re.test(stream.string.charAt(stream.start-1))||stream.pos!=stream.string.length&&re.test(stream.string.charAt(stream.pos)))}function makeOverlay(query,hasBoundary,style){return{token:function(stream){if(stream.match(query)&&(!hasBoundary||boundariesAround(stream,hasBoundary)))return style;stream.next(),stream.skipTo(query.charAt(0))||stream.skipToEnd()}}}var defaults={style:"matchhighlight",minChars:2,delay:100,wordsOnly:!1,annotateScrollbar:!1,showToken:!1,trim:!0};CodeMirror.defineOption("highlightSelectionMatches",!1,function(cm,val,old){if(old&&old!=CodeMirror.Init&&(removeOverlay(cm),clearTimeout(cm.state.matchHighlighter.timeout),cm.state.matchHighlighter=null,cm.off("cursorActivity",cursorActivity),cm.off("focus",onFocus)),val){var state=cm.state.matchHighlighter=new State(val);cm.hasFocus()?(state.active=!0,highlightMatches(cm)):cm.on("focus",onFocus),cm.on("cursorActivity",cursorActivity)}})});